%------------------------------------------------------------------------------
% File     : ITP094^2 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer Liouville_Numbers problem prob_128__5866194_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : Liouville_Numbers/prob_128__5866194_1 [Des21]

% Status   : Theorem
% Rating   : 0.00 v7.5.0
% Syntax   : Number of formulae    :  381 (  99 unt;  64 typ;   0 def)
%            Number of atoms       :  856 ( 300 equ;   0 cnn)
%            Maximal formula atoms :    7 (   2 avg)
%            Number of connectives : 2979 ( 132   ~;  11   |;  83   &;2362   @)
%                                         (   0 <=>; 391  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   19 (   6 avg)
%            Number of types       :    3 (   2 usr)
%            Number of type conns  :  108 ( 108   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   64 (  62 usr;   4 con; 0-7 aty)
%            Number of variables   :  711 (  41   ^; 579   !;  34   ?; 711   :)
%                                         (  57  !>;   0  ?*;   0  @-;   0  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 16:24:32.418
%------------------------------------------------------------------------------
% Could-be-implicit typings (4)
thf(ty_t_Polynomial_Opoly,type,
    poly: $tType > $tType ).

thf(ty_t_Real_Oreal,type,
    real: $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_Nat_Onat,type,
    nat: $tType ).

% Explicit typings (60)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Oone,type,
    one: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oidom,type,
    idom: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ozero,type,
    zero: 
      !>[A: $tType] : $o ).

thf(sy_cl_Fields_Ofield,type,
    field: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oring__1,type,
    ring_1: 
      !>[A: $tType] : $o ).

thf(sy_cl_Nat_Oring__char__0,type,
    ring_char_0: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : $o ).

thf(sy_cl_Finite__Set_Ofinite,type,
    finite_finite: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ocomm__ring__1,type,
    comm_ring_1: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oidom__divide,type,
    idom_divide: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ozero__neq__one,type,
    zero_neq_one: 
      !>[A: $tType] : $o ).

thf(sy_cl_Fields_Ofield__char__0,type,
    field_char_0: 
      !>[A: $tType] : $o ).

thf(sy_cl_Nat_Osemiring__char__0,type,
    semiring_char_0: 
      !>[A: $tType] : $o ).

thf(sy_cl_Orderings_Owellorder,type,
    wellorder: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ozero__less__one,type,
    zero_less_one: 
      !>[A: $tType] : $o ).

thf(sy_cl_Fields_Odivision__ring,type,
    division_ring: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ocomm__semiring__0,type,
    comm_semiring_0: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Ocomm__semiring__1,type,
    comm_semiring_1: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Olinordered__idom,type,
    linordered_idom: 
      !>[A: $tType] : $o ).

thf(sy_cl_Fields_Olinordered__field,type,
    linordered_field: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocomm__monoid__mult,type,
    comm_monoid_mult: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oalgebraic__semidom,type,
    algebraic_semidom: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Oring__no__zero__divisors,type,
    ring_n68954251visors: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Osemiring__no__zero__divisors,type,
    semiri1193490041visors: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Olinordered__nonzero__semiring,type,
    linord1659791738miring: 
      !>[A: $tType] : $o ).

thf(sy_cl_Rings_Osemiring__1__no__zero__divisors,type,
    semiri134348788visors: 
      !>[A: $tType] : $o ).

thf(sy_cl_Groups_Ocanonically__ordered__monoid__add,type,
    canoni770627133id_add: 
      !>[A: $tType] : $o ).

thf(sy_c_Fields_Oinverse__class_Oinverse,type,
    inverse_inverse: 
      !>[A: $tType] : ( A > A ) ).

thf(sy_c_Finite__Set_Ofinite,type,
    finite_finite2: 
      !>[A: $tType] : ( ( set @ A ) > $o ) ).

thf(sy_c_Groups_Oone__class_Oone,type,
    one_one: 
      !>[A: $tType] : A ).

thf(sy_c_Groups_Ozero__class_Ozero,type,
    zero_zero: 
      !>[A: $tType] : A ).

thf(sy_c_Int_Oring__1__class_OInts,type,
    ring_1_Ints: 
      !>[A: $tType] : ( set @ A ) ).

thf(sy_c_Nat_OSuc,type,
    suc: nat > nat ).

thf(sy_c_Orderings_Oord__class_Oless,type,
    ord_less: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Polynomial_Oalgebraic,type,
    algebraic: 
      !>[A: $tType] : ( A > $o ) ).

thf(sy_c_Polynomial_Oalgebraic__int,type,
    algebraic_int: 
      !>[A: $tType] : ( A > $o ) ).

thf(sy_c_Polynomial_Ocr__poly,type,
    cr_poly: 
      !>[A: $tType] : ( ( nat > A ) > ( poly @ A ) > $o ) ).

thf(sy_c_Polynomial_Odegree,type,
    degree: 
      !>[A: $tType] : ( ( poly @ A ) > nat ) ).

thf(sy_c_Polynomial_Odivide__poly__main,type,
    divide_poly_main: 
      !>[A: $tType] : ( A > ( poly @ A ) > ( poly @ A ) > ( poly @ A ) > nat > nat > ( poly @ A ) ) ).

thf(sy_c_Polynomial_Ois__zero,type,
    is_zero: 
      !>[A: $tType] : ( ( poly @ A ) > $o ) ).

thf(sy_c_Polynomial_Oorder,type,
    order2: 
      !>[A: $tType] : ( A > ( poly @ A ) > nat ) ).

thf(sy_c_Polynomial_Opcr__poly,type,
    pcr_poly: 
      !>[C: $tType,B: $tType] : ( ( C > B > $o ) > ( nat > C ) > ( poly @ B ) > $o ) ).

thf(sy_c_Polynomial_Opderiv,type,
    pderiv: 
      !>[A: $tType] : ( ( poly @ A ) > ( poly @ A ) ) ).

thf(sy_c_Polynomial_Opoly,type,
    poly2: 
      !>[A: $tType] : ( ( poly @ A ) > A > A ) ).

thf(sy_c_Polynomial_Opoly_Ocoeff,type,
    coeff: 
      !>[A: $tType] : ( ( poly @ A ) > nat > A ) ).

thf(sy_c_Polynomial_Opoly__cutoff,type,
    poly_cutoff: 
      !>[A: $tType] : ( nat > ( poly @ A ) > ( poly @ A ) ) ).

thf(sy_c_Polynomial_Opoly__shift,type,
    poly_shift: 
      !>[A: $tType] : ( nat > ( poly @ A ) > ( poly @ A ) ) ).

thf(sy_c_Polynomial_Opseudo__mod,type,
    pseudo_mod: 
      !>[A: $tType] : ( ( poly @ A ) > ( poly @ A ) > ( poly @ A ) ) ).

thf(sy_c_Polynomial_Oreflect__poly,type,
    reflect_poly: 
      !>[A: $tType] : ( ( poly @ A ) > ( poly @ A ) ) ).

thf(sy_c_Polynomial_Orsquarefree,type,
    rsquarefree: 
      !>[A: $tType] : ( ( poly @ A ) > $o ) ).

thf(sy_c_Polynomial_Osynthetic__div,type,
    synthetic_div: 
      !>[A: $tType] : ( ( poly @ A ) > A > ( poly @ A ) ) ).

thf(sy_c_Rat_Ofield__char__0__class_ORats,type,
    field_char_0_Rats: 
      !>[A: $tType] : ( set @ A ) ).

thf(sy_c_Rings_Odvd__class_Odvd,type,
    dvd_dvd: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_n____,type,
    n: nat ).

thf(sy_v_p____,type,
    p: poly @ real ).

thf(sy_v_x,type,
    x: real ).

% Relevant facts (252)
thf(fact_0_poly__roots__finite,axiom,
    ! [A: $tType] :
      ( ( ( comm_ring_1 @ A )
        & ( ring_n68954251visors @ A ) )
     => ! [P: poly @ A] :
          ( ( P
           != ( zero_zero @ ( poly @ A ) ) )
         => ( finite_finite2 @ A
            @ ( collect @ A
              @ ^ [X: A] :
                  ( ( poly2 @ A @ P @ X )
                  = ( zero_zero @ A ) ) ) ) ) ) ).

% poly_roots_finite
thf(fact_1_p_I2_J,axiom,
    ( p
   != ( zero_zero @ ( poly @ real ) ) ) ).

% p(2)
thf(fact_2__092_060open_062pderiv_Ap_A_092_060noteq_062_A0_092_060close_062,axiom,
    ( ( pderiv @ real @ p )
   != ( zero_zero @ ( poly @ real ) ) ) ).

% \<open>pderiv p \<noteq> 0\<close>
thf(fact_3_p_I3_J,axiom,
    ( ( poly2 @ real @ p @ x )
    = ( zero_zero @ real ) ) ).

% p(3)
thf(fact_4_poly__0,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_0 @ A )
     => ! [X2: A] :
          ( ( poly2 @ A @ ( zero_zero @ ( poly @ A ) ) @ X2 )
          = ( zero_zero @ A ) ) ) ).

% poly_0
thf(fact_5_finite__Collect__conjI,axiom,
    ! [A: $tType,P2: A > $o,Q: A > $o] :
      ( ( ( finite_finite2 @ A @ ( collect @ A @ P2 ) )
        | ( finite_finite2 @ A @ ( collect @ A @ Q ) ) )
     => ( finite_finite2 @ A
        @ ( collect @ A
          @ ^ [X: A] :
              ( ( P2 @ X )
              & ( Q @ X ) ) ) ) ) ).

% finite_Collect_conjI
thf(fact_6_finite__Collect__disjI,axiom,
    ! [A: $tType,P2: A > $o,Q: A > $o] :
      ( ( finite_finite2 @ A
        @ ( collect @ A
          @ ^ [X: A] :
              ( ( P2 @ X )
              | ( Q @ X ) ) ) )
      = ( ( finite_finite2 @ A @ ( collect @ A @ P2 ) )
        & ( finite_finite2 @ A @ ( collect @ A @ Q ) ) ) ) ).

% finite_Collect_disjI
thf(fact_7_finite__code,axiom,
    ! [A: $tType] :
      ( ( finite_finite @ A )
     => ( ( finite_finite2 @ A )
        = ( ^ [A2: set @ A] : $true ) ) ) ).

% finite_code
thf(fact_8_poly__all__0__iff__0,axiom,
    ! [A: $tType] :
      ( ( ( ring_char_0 @ A )
        & ( comm_ring_1 @ A )
        & ( ring_n68954251visors @ A ) )
     => ! [P: poly @ A] :
          ( ( ! [X: A] :
                ( ( poly2 @ A @ P @ X )
                = ( zero_zero @ A ) ) )
          = ( P
            = ( zero_zero @ ( poly @ A ) ) ) ) ) ).

% poly_all_0_iff_0
thf(fact_9_rsquarefree__roots,axiom,
    ! [A: $tType] :
      ( ( field_char_0 @ A )
     => ( ( rsquarefree @ A )
        = ( ^ [P3: poly @ A] :
            ! [A3: A] :
              ~ ( ( ( poly2 @ A @ P3 @ A3 )
                  = ( zero_zero @ A ) )
                & ( ( poly2 @ A @ ( pderiv @ A @ P3 ) @ A3 )
                  = ( zero_zero @ A ) ) ) ) ) ) ).

% rsquarefree_roots
thf(fact_10_not__finite__existsD,axiom,
    ! [A: $tType,P2: A > $o] :
      ( ~ ( finite_finite2 @ A @ ( collect @ A @ P2 ) )
     => ? [X_1: A] : ( P2 @ X_1 ) ) ).

% not_finite_existsD
thf(fact_11_pigeonhole__infinite__rel,axiom,
    ! [B: $tType,A: $tType,A4: set @ A,B2: set @ B,R: A > B > $o] :
      ( ~ ( finite_finite2 @ A @ A4 )
     => ( ( finite_finite2 @ B @ B2 )
       => ( ! [X3: A] :
              ( ( member @ A @ X3 @ A4 )
             => ? [Xa: B] :
                  ( ( member @ B @ Xa @ B2 )
                  & ( R @ X3 @ Xa ) ) )
         => ? [X3: B] :
              ( ( member @ B @ X3 @ B2 )
              & ~ ( finite_finite2 @ A
                  @ ( collect @ A
                    @ ^ [A3: A] :
                        ( ( member @ A @ A3 @ A4 )
                        & ( R @ A3 @ X3 ) ) ) ) ) ) ) ) ).

% pigeonhole_infinite_rel
thf(fact_12_fun__cong__unused__0,axiom,
    ! [A: $tType,B: $tType,C: $tType] :
      ( ( zero @ B )
     => ! [F: ( A > B ) > C,G: C] :
          ( ( F
            = ( ^ [X: A > B] : G ) )
         => ( ( F
              @ ^ [X: A] : ( zero_zero @ B ) )
            = G ) ) ) ).

% fun_cong_unused_0
thf(fact_13_poly__eq__poly__eq__iff,axiom,
    ! [A: $tType] :
      ( ( ( ring_char_0 @ A )
        & ( comm_ring_1 @ A )
        & ( ring_n68954251visors @ A ) )
     => ! [P: poly @ A,Q2: poly @ A] :
          ( ( ( poly2 @ A @ P )
            = ( poly2 @ A @ Q2 ) )
          = ( P = Q2 ) ) ) ).

% poly_eq_poly_eq_iff
thf(fact_14_n__def,axiom,
    ( n
    = ( degree @ real @ p ) ) ).

% n_def
thf(fact_15_assms_I2_J,axiom,
    algebraic @ real @ x ).

% assms(2)
thf(fact_16_irrationsl,axiom,
    ~ ( member @ real @ x @ ( field_char_0_Rats @ real ) ) ).

% irrationsl
thf(fact_17_degree__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( degree @ A @ ( zero_zero @ ( poly @ A ) ) )
        = ( zero_zero @ nat ) ) ) ).

% degree_0
thf(fact_18_pderiv__0,axiom,
    ! [A: $tType] :
      ( ( ( comm_semiring_1 @ A )
        & ( semiri1193490041visors @ A ) )
     => ( ( pderiv @ A @ ( zero_zero @ ( poly @ A ) ) )
        = ( zero_zero @ ( poly @ A ) ) ) ) ).

% pderiv_0
thf(fact_19_pderiv__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( ( semiring_char_0 @ A )
        & ( comm_semiring_1 @ A )
        & ( semiri1193490041visors @ A ) )
     => ! [P: poly @ A] :
          ( ( ( pderiv @ A @ P )
            = ( zero_zero @ ( poly @ A ) ) )
          = ( ( degree @ A @ P )
            = ( zero_zero @ nat ) ) ) ) ).

% pderiv_eq_0_iff
thf(fact_20_zero__reorient,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [X2: A] :
          ( ( ( zero_zero @ A )
            = X2 )
          = ( X2
            = ( zero_zero @ A ) ) ) ) ).

% zero_reorient
thf(fact_21_finite,axiom,
    ! [A: $tType] :
      ( ( finite_finite @ A )
     => ! [A4: set @ A] : ( finite_finite2 @ A @ A4 ) ) ).

% finite
thf(fact_22_finite__set__choice,axiom,
    ! [B: $tType,A: $tType,A4: set @ A,P2: A > B > $o] :
      ( ( finite_finite2 @ A @ A4 )
     => ( ! [X3: A] :
            ( ( member @ A @ X3 @ A4 )
           => ? [X_12: B] : ( P2 @ X3 @ X_12 ) )
       => ? [F2: A > B] :
          ! [X4: A] :
            ( ( member @ A @ X4 @ A4 )
           => ( P2 @ X4 @ ( F2 @ X4 ) ) ) ) ) ).

% finite_set_choice
thf(fact_23_is__zero__null,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( is_zero @ A )
        = ( ^ [P3: poly @ A] :
              ( P3
              = ( zero_zero @ ( poly @ A ) ) ) ) ) ) ).

% is_zero_null
thf(fact_24_poly__cutoff__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [N: nat] :
          ( ( poly_cutoff @ A @ N @ ( zero_zero @ ( poly @ A ) ) )
          = ( zero_zero @ ( poly @ A ) ) ) ) ).

% poly_cutoff_0
thf(fact_25_reflect__poly__at__0__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_0 @ A )
     => ! [P: poly @ A] :
          ( ( ( poly2 @ A @ ( reflect_poly @ A @ P ) @ ( zero_zero @ A ) )
            = ( zero_zero @ A ) )
          = ( P
            = ( zero_zero @ ( poly @ A ) ) ) ) ) ).

% reflect_poly_at_0_eq_0_iff
thf(fact_26__092_060open_062_092_060And_062thesisa_O_A_I_092_060And_062p_O_A_092_060lbrakk_062_092_060And_062i_O_Acoeff_Ap_Ai_A_092_060in_062_A_092_060int_062_059_Ap_A_092_060noteq_062_A0_059_Apoly_Ap_Ax_A_061_A0_092_060rbrakk_062_A_092_060Longrightarrow_062_Athesisa_J_A_092_060Longrightarrow_062_Athesisa_092_060close_062,axiom,
    ~ ! [P4: poly @ real] :
        ( ! [I: nat] : ( member @ real @ ( coeff @ real @ P4 @ I ) @ ( ring_1_Ints @ real ) )
       => ( ( P4
           != ( zero_zero @ ( poly @ real ) ) )
         => ( ( poly2 @ real @ P4 @ x )
           != ( zero_zero @ real ) ) ) ) ).

% \<open>\<And>thesisa. (\<And>p. \<lbrakk>\<And>i. coeff p i \<in> \<int>; p \<noteq> 0; poly p x = 0\<rbrakk> \<Longrightarrow> thesisa) \<Longrightarrow> thesisa\<close>
thf(fact_27_synthetic__div__eq__0__iff,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_0 @ A )
     => ! [P: poly @ A,C2: A] :
          ( ( ( synthetic_div @ A @ P @ C2 )
            = ( zero_zero @ ( poly @ A ) ) )
          = ( ( degree @ A @ P )
            = ( zero_zero @ nat ) ) ) ) ).

% synthetic_div_eq_0_iff
thf(fact_28_poly__shift__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [N: nat] :
          ( ( poly_shift @ A @ N @ ( zero_zero @ ( poly @ A ) ) )
          = ( zero_zero @ ( poly @ A ) ) ) ) ).

% poly_shift_0
thf(fact_29_order__root,axiom,
    ! [A: $tType] :
      ( ( idom @ A )
     => ! [P: poly @ A,A5: A] :
          ( ( ( poly2 @ A @ P @ A5 )
            = ( zero_zero @ A ) )
          = ( ( P
              = ( zero_zero @ ( poly @ A ) ) )
            | ( ( order2 @ A @ A5 @ P )
             != ( zero_zero @ nat ) ) ) ) ) ).

% order_root
thf(fact_30_leading__coeff__0__iff,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [P: poly @ A] :
          ( ( ( coeff @ A @ P @ ( degree @ A @ P ) )
            = ( zero_zero @ A ) )
          = ( P
            = ( zero_zero @ ( poly @ A ) ) ) ) ) ).

% leading_coeff_0_iff
thf(fact_31_divide__poly__main__0,axiom,
    ! [A: $tType] :
      ( ( idom_divide @ A )
     => ! [R2: poly @ A,D: poly @ A,Dr: nat,N: nat] :
          ( ( divide_poly_main @ A @ ( zero_zero @ A ) @ ( zero_zero @ ( poly @ A ) ) @ R2 @ D @ Dr @ N )
          = ( zero_zero @ ( poly @ A ) ) ) ) ).

% divide_poly_main_0
thf(fact_32_zero__poly_Otransfer,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( pcr_poly @ A @ A
        @ ^ [Y: A,Z: A] : ( Y = Z )
        @ ^ [Uu: nat] : ( zero_zero @ A )
        @ ( zero_zero @ ( poly @ A ) ) ) ) ).

% zero_poly.transfer
thf(fact_33_p_I1_J,axiom,
    ! [I2: nat] : ( member @ real @ ( coeff @ real @ p @ I2 ) @ ( ring_1_Ints @ real ) ) ).

% p(1)
thf(fact_34_reflect__poly__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( reflect_poly @ A @ ( zero_zero @ ( poly @ A ) ) )
        = ( zero_zero @ ( poly @ A ) ) ) ) ).

% reflect_poly_0
thf(fact_35_synthetic__div__0,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_0 @ A )
     => ! [C2: A] :
          ( ( synthetic_div @ A @ ( zero_zero @ ( poly @ A ) ) @ C2 )
          = ( zero_zero @ ( poly @ A ) ) ) ) ).

% synthetic_div_0
thf(fact_36_poly__shift__id,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( poly_shift @ A @ ( zero_zero @ nat ) )
        = ( ^ [X: poly @ A] : X ) ) ) ).

% poly_shift_id
thf(fact_37_coeff__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [N: nat] :
          ( ( coeff @ A @ ( zero_zero @ ( poly @ A ) ) @ N )
          = ( zero_zero @ A ) ) ) ).

% coeff_0
thf(fact_38_reflect__poly__reflect__poly,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [P: poly @ A] :
          ( ( ( coeff @ A @ P @ ( zero_zero @ nat ) )
           != ( zero_zero @ A ) )
         => ( ( reflect_poly @ A @ ( reflect_poly @ A @ P ) )
            = P ) ) ) ).

% reflect_poly_reflect_poly
thf(fact_39_coeff__0__reflect__poly,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [P: poly @ A] :
          ( ( coeff @ A @ ( reflect_poly @ A @ P ) @ ( zero_zero @ nat ) )
          = ( coeff @ A @ P @ ( degree @ A @ P ) ) ) ) ).

% coeff_0_reflect_poly
thf(fact_40_coeff__0__reflect__poly__0__iff,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [P: poly @ A] :
          ( ( ( coeff @ A @ ( reflect_poly @ A @ P ) @ ( zero_zero @ nat ) )
            = ( zero_zero @ A ) )
          = ( P
            = ( zero_zero @ ( poly @ A ) ) ) ) ) ).

% coeff_0_reflect_poly_0_iff
thf(fact_41_degree__reflect__poly__eq,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [P: poly @ A] :
          ( ( ( coeff @ A @ P @ ( zero_zero @ nat ) )
           != ( zero_zero @ A ) )
         => ( ( degree @ A @ ( reflect_poly @ A @ P ) )
            = ( degree @ A @ P ) ) ) ) ).

% degree_reflect_poly_eq
thf(fact_42_poly__reflect__poly__0,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_0 @ A )
     => ! [P: poly @ A] :
          ( ( poly2 @ A @ ( reflect_poly @ A @ P ) @ ( zero_zero @ A ) )
          = ( coeff @ A @ P @ ( degree @ A @ P ) ) ) ) ).

% poly_reflect_poly_0
thf(fact_43_divide__poly__main_Osimps_I2_J,axiom,
    ! [A: $tType] :
      ( ( idom_divide @ A )
     => ! [Lc: A,Q2: poly @ A,R2: poly @ A,D: poly @ A,Dr: nat] :
          ( ( divide_poly_main @ A @ Lc @ Q2 @ R2 @ D @ Dr @ ( zero_zero @ nat ) )
          = Q2 ) ) ).

% divide_poly_main.simps(2)
thf(fact_44_mem__Collect__eq,axiom,
    ! [A: $tType,A5: A,P2: A > $o] :
      ( ( member @ A @ A5 @ ( collect @ A @ P2 ) )
      = ( P2 @ A5 ) ) ).

% mem_Collect_eq
thf(fact_45_Collect__mem__eq,axiom,
    ! [A: $tType,A4: set @ A] :
      ( ( collect @ A
        @ ^ [X: A] : ( member @ A @ X @ A4 ) )
      = A4 ) ).

% Collect_mem_eq
thf(fact_46_Collect__cong,axiom,
    ! [A: $tType,P2: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P2 @ X3 )
          = ( Q @ X3 ) )
     => ( ( collect @ A @ P2 )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_47_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G: A > B] :
      ( ! [X3: A] :
          ( ( F @ X3 )
          = ( G @ X3 ) )
     => ( F = G ) ) ).

% ext
thf(fact_48_poly__eqI,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [P: poly @ A,Q2: poly @ A] :
          ( ! [N2: nat] :
              ( ( coeff @ A @ P @ N2 )
              = ( coeff @ A @ Q2 @ N2 ) )
         => ( P = Q2 ) ) ) ).

% poly_eqI
thf(fact_49_poly__eq__iff,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( ^ [Y: poly @ A,Z: poly @ A] : ( Y = Z ) )
        = ( ^ [P3: poly @ A,Q3: poly @ A] :
            ! [N3: nat] :
              ( ( coeff @ A @ P3 @ N3 )
              = ( coeff @ A @ Q3 @ N3 ) ) ) ) ) ).

% poly_eq_iff
thf(fact_50_coeff__inject,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [X2: poly @ A,Y2: poly @ A] :
          ( ( ( coeff @ A @ X2 )
            = ( coeff @ A @ Y2 ) )
          = ( X2 = Y2 ) ) ) ).

% coeff_inject
thf(fact_51_algebraicE,axiom,
    ! [A: $tType] :
      ( ( field_char_0 @ A )
     => ! [X2: A] :
          ( ( algebraic @ A @ X2 )
         => ~ ! [P4: poly @ A] :
                ( ! [I: nat] : ( member @ A @ ( coeff @ A @ P4 @ I ) @ ( ring_1_Ints @ A ) )
               => ( ( P4
                   != ( zero_zero @ ( poly @ A ) ) )
                 => ( ( poly2 @ A @ P4 @ X2 )
                   != ( zero_zero @ A ) ) ) ) ) ) ).

% algebraicE
thf(fact_52_algebraicI,axiom,
    ! [A: $tType] :
      ( ( field_char_0 @ A )
     => ! [P: poly @ A,X2: A] :
          ( ! [I3: nat] : ( member @ A @ ( coeff @ A @ P @ I3 ) @ ( ring_1_Ints @ A ) )
         => ( ( P
             != ( zero_zero @ ( poly @ A ) ) )
           => ( ( ( poly2 @ A @ P @ X2 )
                = ( zero_zero @ A ) )
             => ( algebraic @ A @ X2 ) ) ) ) ) ).

% algebraicI
thf(fact_53_algebraic__def,axiom,
    ! [A: $tType] :
      ( ( field_char_0 @ A )
     => ( ( algebraic @ A )
        = ( ^ [X: A] :
            ? [P3: poly @ A] :
              ( ! [I4: nat] : ( member @ A @ ( coeff @ A @ P3 @ I4 ) @ ( ring_1_Ints @ A ) )
              & ( P3
               != ( zero_zero @ ( poly @ A ) ) )
              & ( ( poly2 @ A @ P3 @ X )
                = ( zero_zero @ A ) ) ) ) ) ) ).

% algebraic_def
thf(fact_54_algebraic__altdef,axiom,
    ! [B: $tType] :
      ( ( field_char_0 @ B )
     => ( ( algebraic @ B )
        = ( ^ [X: B] :
            ? [P3: poly @ B] :
              ( ! [I4: nat] : ( member @ B @ ( coeff @ B @ P3 @ I4 ) @ ( field_char_0_Rats @ B ) )
              & ( P3
               != ( zero_zero @ ( poly @ B ) ) )
              & ( ( poly2 @ B @ P3 @ X )
                = ( zero_zero @ B ) ) ) ) ) ) ).

% algebraic_altdef
thf(fact_55_zero__poly_Orep__eq,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( coeff @ A @ ( zero_zero @ ( poly @ A ) ) )
        = ( ^ [Uu: nat] : ( zero_zero @ A ) ) ) ) ).

% zero_poly.rep_eq
thf(fact_56_poly__0__coeff__0,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_0 @ A )
     => ! [P: poly @ A] :
          ( ( poly2 @ A @ P @ ( zero_zero @ A ) )
          = ( coeff @ A @ P @ ( zero_zero @ nat ) ) ) ) ).

% poly_0_coeff_0
thf(fact_57_order__0I,axiom,
    ! [A: $tType] :
      ( ( idom @ A )
     => ! [P: poly @ A,A5: A] :
          ( ( ( poly2 @ A @ P @ A5 )
           != ( zero_zero @ A ) )
         => ( ( order2 @ A @ A5 @ P )
            = ( zero_zero @ nat ) ) ) ) ).

% order_0I
thf(fact_58_leading__coeff__neq__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [P: poly @ A] :
          ( ( P
           != ( zero_zero @ ( poly @ A ) ) )
         => ( ( coeff @ A @ P @ ( degree @ A @ P ) )
           != ( zero_zero @ A ) ) ) ) ).

% leading_coeff_neq_0
thf(fact_59_Rats__infinite,axiom,
    ! [A: $tType] :
      ( ( field_char_0 @ A )
     => ~ ( finite_finite2 @ A @ ( field_char_0_Rats @ A ) ) ) ).

% Rats_infinite
thf(fact_60_Rats__0,axiom,
    ! [A: $tType] :
      ( ( field_char_0 @ A )
     => ( member @ A @ ( zero_zero @ A ) @ ( field_char_0_Rats @ A ) ) ) ).

% Rats_0
thf(fact_61_Ints__0,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ( member @ A @ ( zero_zero @ A ) @ ( ring_1_Ints @ A ) ) ) ).

% Ints_0
thf(fact_62_rsquarefree__def,axiom,
    ! [A: $tType] :
      ( ( idom @ A )
     => ( ( rsquarefree @ A )
        = ( ^ [P3: poly @ A] :
              ( ( P3
               != ( zero_zero @ ( poly @ A ) ) )
              & ! [A3: A] :
                  ( ( ( order2 @ A @ A3 @ P3 )
                    = ( zero_zero @ nat ) )
                  | ( ( order2 @ A @ A3 @ P3 )
                    = ( one_one @ nat ) ) ) ) ) ) ) ).

% rsquarefree_def
thf(fact_63_poly__cutoff__1,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ! [N: nat] :
          ( ( ( N
              = ( zero_zero @ nat ) )
           => ( ( poly_cutoff @ A @ N @ ( one_one @ ( poly @ A ) ) )
              = ( zero_zero @ ( poly @ A ) ) ) )
          & ( ( N
             != ( zero_zero @ nat ) )
           => ( ( poly_cutoff @ A @ N @ ( one_one @ ( poly @ A ) ) )
              = ( one_one @ ( poly @ A ) ) ) ) ) ) ).

% poly_cutoff_1
thf(fact_64_order__pderiv2,axiom,
    ! [A: $tType] :
      ( ( field_char_0 @ A )
     => ! [P: poly @ A,A5: A,N: nat] :
          ( ( ( pderiv @ A @ P )
           != ( zero_zero @ ( poly @ A ) ) )
         => ( ( ( order2 @ A @ A5 @ P )
             != ( zero_zero @ nat ) )
           => ( ( ( order2 @ A @ A5 @ ( pderiv @ A @ P ) )
                = N )
              = ( ( order2 @ A @ A5 @ P )
                = ( suc @ N ) ) ) ) ) ) ).

% order_pderiv2
thf(fact_65_order__pderiv,axiom,
    ! [A: $tType] :
      ( ( field_char_0 @ A )
     => ! [P: poly @ A,A5: A] :
          ( ( ( pderiv @ A @ P )
           != ( zero_zero @ ( poly @ A ) ) )
         => ( ( ( order2 @ A @ A5 @ P )
             != ( zero_zero @ nat ) )
           => ( ( order2 @ A @ A5 @ P )
              = ( suc @ ( order2 @ A @ A5 @ ( pderiv @ A @ P ) ) ) ) ) ) ) ).

% order_pderiv
thf(fact_66_cr__poly__def,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ( ( cr_poly @ A )
        = ( ^ [X: nat > A,Y3: poly @ A] :
              ( X
              = ( coeff @ A @ Y3 ) ) ) ) ) ).

% cr_poly_def
thf(fact_67_dvd__pderiv__iff,axiom,
    ! [A: $tType] :
      ( ( ( semiring_char_0 @ A )
        & ( comm_semiring_1 @ A )
        & ( semiri1193490041visors @ A ) )
     => ! [P: poly @ A] :
          ( ( dvd_dvd @ ( poly @ A ) @ P @ ( pderiv @ A @ P ) )
          = ( ( degree @ A @ P )
            = ( zero_zero @ nat ) ) ) ) ).

% dvd_pderiv_iff
thf(fact_68_reflect__poly__1,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ( ( reflect_poly @ A @ ( one_one @ ( poly @ A ) ) )
        = ( one_one @ ( poly @ A ) ) ) ) ).

% reflect_poly_1
thf(fact_69_degree__1,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ( ( degree @ A @ ( one_one @ ( poly @ A ) ) )
        = ( zero_zero @ nat ) ) ) ).

% degree_1
thf(fact_70_poly__1,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ! [X2: A] :
          ( ( poly2 @ A @ ( one_one @ ( poly @ A ) ) @ X2 )
          = ( one_one @ A ) ) ) ).

% poly_1
thf(fact_71_pderiv__1,axiom,
    ! [A: $tType] :
      ( ( ( comm_semiring_1 @ A )
        & ( semiri1193490041visors @ A ) )
     => ( ( pderiv @ A @ ( one_one @ ( poly @ A ) ) )
        = ( zero_zero @ ( poly @ A ) ) ) ) ).

% pderiv_1
thf(fact_72_order__1__eq__0,axiom,
    ! [A: $tType] :
      ( ( idom @ A )
     => ! [X2: A] :
          ( ( order2 @ A @ X2 @ ( one_one @ ( poly @ A ) ) )
          = ( zero_zero @ nat ) ) ) ).

% order_1_eq_0
thf(fact_73_lead__coeff__1,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ( ( coeff @ A @ ( one_one @ ( poly @ A ) ) @ ( degree @ A @ ( one_one @ ( poly @ A ) ) ) )
        = ( one_one @ A ) ) ) ).

% lead_coeff_1
thf(fact_74_one__reorient,axiom,
    ! [A: $tType] :
      ( ( one @ A )
     => ! [X2: A] :
          ( ( ( one_one @ A )
            = X2 )
          = ( X2
            = ( one_one @ A ) ) ) ) ).

% one_reorient
thf(fact_75_Ints__1,axiom,
    ! [A: $tType] :
      ( ( ring_1 @ A )
     => ( member @ A @ ( one_one @ A ) @ ( ring_1_Ints @ A ) ) ) ).

% Ints_1
thf(fact_76_Rats__1,axiom,
    ! [A: $tType] :
      ( ( field_char_0 @ A )
     => ( member @ A @ ( one_one @ A ) @ ( field_char_0_Rats @ A ) ) ) ).

% Rats_1
thf(fact_77_is__unit__iff__degree,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [P: poly @ A] :
          ( ( P
           != ( zero_zero @ ( poly @ A ) ) )
         => ( ( dvd_dvd @ ( poly @ A ) @ P @ ( one_one @ ( poly @ A ) ) )
            = ( ( degree @ A @ P )
              = ( zero_zero @ nat ) ) ) ) ) ).

% is_unit_iff_degree
thf(fact_78_not__dvd__pderiv,axiom,
    ! [A: $tType] :
      ( ( ( semiring_char_0 @ A )
        & ( comm_semiring_1 @ A )
        & ( semiri1193490041visors @ A ) )
     => ! [P: poly @ A] :
          ( ( ( degree @ A @ P )
           != ( zero_zero @ nat ) )
         => ~ ( dvd_dvd @ ( poly @ A ) @ P @ ( pderiv @ A @ P ) ) ) ) ).

% not_dvd_pderiv
thf(fact_79_poly_Opcr__cr__eq,axiom,
    ! [D2: $tType] :
      ( ( zero @ D2 )
     => ( ( pcr_poly @ D2 @ D2
          @ ^ [Y: D2,Z: D2] : ( Y = Z ) )
        = ( cr_poly @ D2 ) ) ) ).

% poly.pcr_cr_eq
thf(fact_80_poly__shift__1,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ! [N: nat] :
          ( ( ( N
              = ( zero_zero @ nat ) )
           => ( ( poly_shift @ A @ N @ ( one_one @ ( poly @ A ) ) )
              = ( one_one @ ( poly @ A ) ) ) )
          & ( ( N
             != ( zero_zero @ nat ) )
           => ( ( poly_shift @ A @ N @ ( one_one @ ( poly @ A ) ) )
              = ( zero_zero @ ( poly @ A ) ) ) ) ) ) ).

% poly_shift_1
thf(fact_81_dvd__0__left__iff,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ! [A5: A] :
          ( ( dvd_dvd @ A @ ( zero_zero @ A ) @ A5 )
          = ( A5
            = ( zero_zero @ A ) ) ) ) ).

% dvd_0_left_iff
thf(fact_82_dvd__0__right,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ! [A5: A] : ( dvd_dvd @ A @ A5 @ ( zero_zero @ A ) ) ) ).

% dvd_0_right
thf(fact_83_One__nat__def,axiom,
    ( ( one_one @ nat )
    = ( suc @ ( zero_zero @ nat ) ) ) ).

% One_nat_def
thf(fact_84_not__is__unit__0,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A )
     => ~ ( dvd_dvd @ A @ ( zero_zero @ A ) @ ( one_one @ A ) ) ) ).

% not_is_unit_0
thf(fact_85_nat_Oinject,axiom,
    ! [X22: nat,Y22: nat] :
      ( ( ( suc @ X22 )
        = ( suc @ Y22 ) )
      = ( X22 = Y22 ) ) ).

% nat.inject
thf(fact_86_old_Onat_Oinject,axiom,
    ! [Nat: nat,Nat2: nat] :
      ( ( ( suc @ Nat )
        = ( suc @ Nat2 ) )
      = ( Nat = Nat2 ) ) ).

% old.nat.inject
thf(fact_87_nat__dvd__1__iff__1,axiom,
    ! [M: nat] :
      ( ( dvd_dvd @ nat @ M @ ( one_one @ nat ) )
      = ( M
        = ( one_one @ nat ) ) ) ).

% nat_dvd_1_iff_1
thf(fact_88_dvd__1__iff__1,axiom,
    ! [M: nat] :
      ( ( dvd_dvd @ nat @ M @ ( suc @ ( zero_zero @ nat ) ) )
      = ( M
        = ( suc @ ( zero_zero @ nat ) ) ) ) ).

% dvd_1_iff_1
thf(fact_89_dvd__1__left,axiom,
    ! [K: nat] : ( dvd_dvd @ nat @ ( suc @ ( zero_zero @ nat ) ) @ K ) ).

% dvd_1_left
thf(fact_90_dvd__trans,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A )
     => ! [A5: A,B3: A,C2: A] :
          ( ( dvd_dvd @ A @ A5 @ B3 )
         => ( ( dvd_dvd @ A @ B3 @ C2 )
           => ( dvd_dvd @ A @ A5 @ C2 ) ) ) ) ).

% dvd_trans
thf(fact_91_dvd__refl,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A )
     => ! [A5: A] : ( dvd_dvd @ A @ A5 @ A5 ) ) ).

% dvd_refl
thf(fact_92_n__not__Suc__n,axiom,
    ! [N: nat] :
      ( N
     != ( suc @ N ) ) ).

% n_not_Suc_n
thf(fact_93_Suc__inject,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( ( suc @ X2 )
        = ( suc @ Y2 ) )
     => ( X2 = Y2 ) ) ).

% Suc_inject
thf(fact_94_zero__neq__one,axiom,
    ! [A: $tType] :
      ( ( zero_neq_one @ A )
     => ( ( zero_zero @ A )
       != ( one_one @ A ) ) ) ).

% zero_neq_one
thf(fact_95_dvd__0__left,axiom,
    ! [A: $tType] :
      ( ( comm_semiring_1 @ A )
     => ! [A5: A] :
          ( ( dvd_dvd @ A @ ( zero_zero @ A ) @ A5 )
         => ( A5
            = ( zero_zero @ A ) ) ) ) ).

% dvd_0_left
thf(fact_96_dvd__unit__imp__unit,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A )
     => ! [A5: A,B3: A] :
          ( ( dvd_dvd @ A @ A5 @ B3 )
         => ( ( dvd_dvd @ A @ B3 @ ( one_one @ A ) )
           => ( dvd_dvd @ A @ A5 @ ( one_one @ A ) ) ) ) ) ).

% dvd_unit_imp_unit
thf(fact_97_unit__imp__dvd,axiom,
    ! [A: $tType] :
      ( ( algebraic_semidom @ A )
     => ! [B3: A,A5: A] :
          ( ( dvd_dvd @ A @ B3 @ ( one_one @ A ) )
         => ( dvd_dvd @ A @ B3 @ A5 ) ) ) ).

% unit_imp_dvd
thf(fact_98_one__dvd,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A )
     => ! [A5: A] : ( dvd_dvd @ A @ ( one_one @ A ) @ A5 ) ) ).

% one_dvd
thf(fact_99_not0__implies__Suc,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
     => ? [M2: nat] :
          ( N
          = ( suc @ M2 ) ) ) ).

% not0_implies_Suc
thf(fact_100_old_Onat_Oinducts,axiom,
    ! [P2: nat > $o,Nat: nat] :
      ( ( P2 @ ( zero_zero @ nat ) )
     => ( ! [Nat3: nat] :
            ( ( P2 @ Nat3 )
           => ( P2 @ ( suc @ Nat3 ) ) )
       => ( P2 @ Nat ) ) ) ).

% old.nat.inducts
thf(fact_101_old_Onat_Oexhaust,axiom,
    ! [Y2: nat] :
      ( ( Y2
       != ( zero_zero @ nat ) )
     => ~ ! [Nat3: nat] :
            ( Y2
           != ( suc @ Nat3 ) ) ) ).

% old.nat.exhaust
thf(fact_102_Zero__not__Suc,axiom,
    ! [M: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ M ) ) ).

% Zero_not_Suc
thf(fact_103_Zero__neq__Suc,axiom,
    ! [M: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ M ) ) ).

% Zero_neq_Suc
thf(fact_104_Suc__neq__Zero,axiom,
    ! [M: nat] :
      ( ( suc @ M )
     != ( zero_zero @ nat ) ) ).

% Suc_neq_Zero
thf(fact_105_zero__induct,axiom,
    ! [P2: nat > $o,K: nat] :
      ( ( P2 @ K )
     => ( ! [N2: nat] :
            ( ( P2 @ ( suc @ N2 ) )
           => ( P2 @ N2 ) )
       => ( P2 @ ( zero_zero @ nat ) ) ) ) ).

% zero_induct
thf(fact_106_diff__induct,axiom,
    ! [P2: nat > nat > $o,M: nat,N: nat] :
      ( ! [X3: nat] : ( P2 @ X3 @ ( zero_zero @ nat ) )
     => ( ! [Y4: nat] : ( P2 @ ( zero_zero @ nat ) @ ( suc @ Y4 ) )
       => ( ! [X3: nat,Y4: nat] :
              ( ( P2 @ X3 @ Y4 )
             => ( P2 @ ( suc @ X3 ) @ ( suc @ Y4 ) ) )
         => ( P2 @ M @ N ) ) ) ) ).

% diff_induct
thf(fact_107_nat__induct,axiom,
    ! [P2: nat > $o,N: nat] :
      ( ( P2 @ ( zero_zero @ nat ) )
     => ( ! [N2: nat] :
            ( ( P2 @ N2 )
           => ( P2 @ ( suc @ N2 ) ) )
       => ( P2 @ N ) ) ) ).

% nat_induct
thf(fact_108_nat_OdiscI,axiom,
    ! [Nat: nat,X22: nat] :
      ( ( Nat
        = ( suc @ X22 ) )
     => ( Nat
       != ( zero_zero @ nat ) ) ) ).

% nat.discI
thf(fact_109_old_Onat_Odistinct_I1_J,axiom,
    ! [Nat2: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ Nat2 ) ) ).

% old.nat.distinct(1)
thf(fact_110_old_Onat_Odistinct_I2_J,axiom,
    ! [Nat4: nat] :
      ( ( suc @ Nat4 )
     != ( zero_zero @ nat ) ) ).

% old.nat.distinct(2)
thf(fact_111_nat_Odistinct_I1_J,axiom,
    ! [X22: nat] :
      ( ( zero_zero @ nat )
     != ( suc @ X22 ) ) ).

% nat.distinct(1)
thf(fact_112_algebraic__int_Oinducts,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [X2: A,P2: A > $o] :
          ( ( algebraic_int @ A @ X2 )
         => ( ! [P4: poly @ A,X3: A] :
                ( ( ( coeff @ A @ P4 @ ( degree @ A @ P4 ) )
                  = ( one_one @ A ) )
               => ( ! [I: nat] : ( member @ A @ ( coeff @ A @ P4 @ I ) @ ( ring_1_Ints @ A ) )
                 => ( ( ( poly2 @ A @ P4 @ X3 )
                      = ( zero_zero @ A ) )
                   => ( P2 @ X3 ) ) ) )
           => ( P2 @ X2 ) ) ) ) ).

% algebraic_int.inducts
thf(fact_113_algebraic__int_Ointros,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [P: poly @ A,X2: A] :
          ( ( ( coeff @ A @ P @ ( degree @ A @ P ) )
            = ( one_one @ A ) )
         => ( ! [I3: nat] : ( member @ A @ ( coeff @ A @ P @ I3 ) @ ( ring_1_Ints @ A ) )
           => ( ( ( poly2 @ A @ P @ X2 )
                = ( zero_zero @ A ) )
             => ( algebraic_int @ A @ X2 ) ) ) ) ) ).

% algebraic_int.intros
thf(fact_114_algebraic__int_Osimps,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ( ( algebraic_int @ A )
        = ( ^ [A3: A] :
            ? [P3: poly @ A,X: A] :
              ( ( A3 = X )
              & ( ( coeff @ A @ P3 @ ( degree @ A @ P3 ) )
                = ( one_one @ A ) )
              & ! [I4: nat] : ( member @ A @ ( coeff @ A @ P3 @ I4 ) @ ( ring_1_Ints @ A ) )
              & ( ( poly2 @ A @ P3 @ X )
                = ( zero_zero @ A ) ) ) ) ) ) ).

% algebraic_int.simps
thf(fact_115_algebraic__int_Ocases,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [A5: A] :
          ( ( algebraic_int @ A @ A5 )
         => ~ ! [P4: poly @ A] :
                ( ( ( coeff @ A @ P4 @ ( degree @ A @ P4 ) )
                  = ( one_one @ A ) )
               => ( ! [I: nat] : ( member @ A @ ( coeff @ A @ P4 @ I ) @ ( ring_1_Ints @ A ) )
                 => ( ( poly2 @ A @ P4 @ A5 )
                   != ( zero_zero @ A ) ) ) ) ) ) ).

% algebraic_int.cases
thf(fact_116_exists__least__lemma,axiom,
    ! [P2: nat > $o] :
      ( ~ ( P2 @ ( zero_zero @ nat ) )
     => ( ? [X_12: nat] : ( P2 @ X_12 )
       => ? [N2: nat] :
            ( ~ ( P2 @ N2 )
            & ( P2 @ ( suc @ N2 ) ) ) ) ) ).

% exists_least_lemma
thf(fact_117_dependent__nat__choice,axiom,
    ! [A: $tType,P2: nat > A > $o,Q: nat > A > A > $o] :
      ( ? [X_12: A] : ( P2 @ ( zero_zero @ nat ) @ X_12 )
     => ( ! [X3: A,N2: nat] :
            ( ( P2 @ N2 @ X3 )
           => ? [Y5: A] :
                ( ( P2 @ ( suc @ N2 ) @ Y5 )
                & ( Q @ N2 @ X3 @ Y5 ) ) )
       => ? [F2: nat > A] :
          ! [N4: nat] :
            ( ( P2 @ N4 @ ( F2 @ N4 ) )
            & ( Q @ N4 @ ( F2 @ N4 ) @ ( F2 @ ( suc @ N4 ) ) ) ) ) ) ).

% dependent_nat_choice
thf(fact_118_algebraic__int__0,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ( algebraic_int @ A @ ( zero_zero @ A ) ) ) ).

% algebraic_int_0
thf(fact_119_algebraic__int__1,axiom,
    ! [B: $tType] :
      ( ( field @ B )
     => ( algebraic_int @ B @ ( one_one @ B ) ) ) ).

% algebraic_int_1
thf(fact_120_dvd__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ( dvd_dvd @ nat @ M @ N )
     => ( ( dvd_dvd @ nat @ N @ M )
       => ( M = N ) ) ) ).

% dvd_antisym
thf(fact_121_int__imp__algebraic__int,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [X2: A] :
          ( ( member @ A @ X2 @ ( ring_1_Ints @ A ) )
         => ( algebraic_int @ A @ X2 ) ) ) ).

% int_imp_algebraic_int
thf(fact_122_algebraic__int__imp__algebraic,axiom,
    ! [A: $tType] :
      ( ( field_char_0 @ A )
     => ! [X2: A] :
          ( ( algebraic_int @ A @ X2 )
         => ( algebraic @ A @ X2 ) ) ) ).

% algebraic_int_imp_algebraic
thf(fact_123_rational__algebraic__int__is__int,axiom,
    ! [A: $tType] :
      ( ( field_char_0 @ A )
     => ! [X2: A] :
          ( ( algebraic_int @ A @ X2 )
         => ( ( member @ A @ X2 @ ( field_char_0_Rats @ A ) )
           => ( member @ A @ X2 @ ( ring_1_Ints @ A ) ) ) ) ) ).

% rational_algebraic_int_is_int
thf(fact_124_algebraic__int__inverse,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [P: poly @ A,X2: A] :
          ( ( ( poly2 @ A @ P @ X2 )
            = ( zero_zero @ A ) )
         => ( ! [I3: nat] : ( member @ A @ ( coeff @ A @ P @ I3 ) @ ( ring_1_Ints @ A ) )
           => ( ( ( coeff @ A @ P @ ( zero_zero @ nat ) )
                = ( one_one @ A ) )
             => ( algebraic_int @ A @ ( inverse_inverse @ A @ X2 ) ) ) ) ) ) ).

% algebraic_int_inverse
thf(fact_125_algebraic__int__root,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [Y2: A,P: poly @ A,X2: A] :
          ( ( algebraic_int @ A @ Y2 )
         => ( ( ( poly2 @ A @ P @ X2 )
              = Y2 )
           => ( ! [I3: nat] : ( member @ A @ ( coeff @ A @ P @ I3 ) @ ( ring_1_Ints @ A ) )
             => ( ( ( coeff @ A @ P @ ( degree @ A @ P ) )
                  = ( one_one @ A ) )
               => ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( degree @ A @ P ) )
                 => ( algebraic_int @ A @ X2 ) ) ) ) ) ) ) ).

% algebraic_int_root
thf(fact_126_gcd__nat_Oextremum__uniqueI,axiom,
    ! [A5: nat] :
      ( ( dvd_dvd @ nat @ ( zero_zero @ nat ) @ A5 )
     => ( A5
        = ( zero_zero @ nat ) ) ) ).

% gcd_nat.extremum_uniqueI
thf(fact_127_gcd__nat_Onot__eq__extremum,axiom,
    ! [A5: nat] :
      ( ( A5
       != ( zero_zero @ nat ) )
      = ( ( dvd_dvd @ nat @ A5 @ ( zero_zero @ nat ) )
        & ( A5
         != ( zero_zero @ nat ) ) ) ) ).

% gcd_nat.not_eq_extremum
thf(fact_128_finite__Collect__less__nat,axiom,
    ! [K: nat] :
      ( finite_finite2 @ nat
      @ ( collect @ nat
        @ ^ [N3: nat] : ( ord_less @ nat @ N3 @ K ) ) ) ).

% finite_Collect_less_nat
thf(fact_129_not__gr__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ~ ( ord_less @ A @ ( zero_zero @ A ) @ N ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% not_gr_zero
thf(fact_130_bot__nat__0_Onot__eq__extremum,axiom,
    ! [A5: nat] :
      ( ( A5
       != ( zero_zero @ nat ) )
      = ( ord_less @ nat @ ( zero_zero @ nat ) @ A5 ) ) ).

% bot_nat_0.not_eq_extremum
thf(fact_131_less__nat__zero__code,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% less_nat_zero_code
thf(fact_132_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
      = ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ).

% neq0_conv
thf(fact_133_lessI,axiom,
    ! [N: nat] : ( ord_less @ nat @ N @ ( suc @ N ) ) ).

% lessI
thf(fact_134_Suc__mono,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( ord_less @ nat @ ( suc @ M ) @ ( suc @ N ) ) ) ).

% Suc_mono
thf(fact_135_Suc__less__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( suc @ M ) @ ( suc @ N ) )
      = ( ord_less @ nat @ M @ N ) ) ).

% Suc_less_eq
thf(fact_136_zero__less__Suc,axiom,
    ! [N: nat] : ( ord_less @ nat @ ( zero_zero @ nat ) @ ( suc @ N ) ) ).

% zero_less_Suc
thf(fact_137_less__Suc0,axiom,
    ! [N: nat] :
      ( ( ord_less @ nat @ N @ ( suc @ ( zero_zero @ nat ) ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% less_Suc0
thf(fact_138_less__one,axiom,
    ! [N: nat] :
      ( ( ord_less @ nat @ N @ ( one_one @ nat ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% less_one
thf(fact_139_zero__less__iff__neq__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ N )
          = ( N
           != ( zero_zero @ A ) ) ) ) ).

% zero_less_iff_neq_zero
thf(fact_140_gr__implies__not__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [M: A,N: A] :
          ( ( ord_less @ A @ M @ N )
         => ( N
           != ( zero_zero @ A ) ) ) ) ).

% gr_implies_not_zero
thf(fact_141_not__less__zero,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ~ ( ord_less @ A @ N @ ( zero_zero @ A ) ) ) ).

% not_less_zero
thf(fact_142_gr__zeroI,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( N
           != ( zero_zero @ A ) )
         => ( ord_less @ A @ ( zero_zero @ A ) @ N ) ) ) ).

% gr_zeroI
thf(fact_143_gr0I,axiom,
    ! [N: nat] :
      ( ( N
       != ( zero_zero @ nat ) )
     => ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) ) ).

% gr0I
thf(fact_144_not__gr0,axiom,
    ! [N: nat] :
      ( ( ~ ( ord_less @ nat @ ( zero_zero @ nat ) @ N ) )
      = ( N
        = ( zero_zero @ nat ) ) ) ).

% not_gr0
thf(fact_145_not__less0,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% not_less0
thf(fact_146_less__zeroE,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ ( zero_zero @ nat ) ) ).

% less_zeroE
thf(fact_147_gr__implies__not0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( N
       != ( zero_zero @ nat ) ) ) ).

% gr_implies_not0
thf(fact_148_infinite__descent0,axiom,
    ! [P2: nat > $o,N: nat] :
      ( ( P2 @ ( zero_zero @ nat ) )
     => ( ! [N2: nat] :
            ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N2 )
           => ( ~ ( P2 @ N2 )
             => ? [M3: nat] :
                  ( ( ord_less @ nat @ M3 @ N2 )
                  & ~ ( P2 @ M3 ) ) ) )
       => ( P2 @ N ) ) ) ).

% infinite_descent0
thf(fact_149_bot__nat__0_Oextremum__strict,axiom,
    ! [A5: nat] :
      ~ ( ord_less @ nat @ A5 @ ( zero_zero @ nat ) ) ).

% bot_nat_0.extremum_strict
thf(fact_150_infinite__descent0__measure,axiom,
    ! [A: $tType,V: A > nat,P2: A > $o,X2: A] :
      ( ! [X3: A] :
          ( ( ( V @ X3 )
            = ( zero_zero @ nat ) )
         => ( P2 @ X3 ) )
     => ( ! [X3: A] :
            ( ( ord_less @ nat @ ( zero_zero @ nat ) @ ( V @ X3 ) )
           => ( ~ ( P2 @ X3 )
             => ? [Y5: A] :
                  ( ( ord_less @ nat @ ( V @ Y5 ) @ ( V @ X3 ) )
                  & ~ ( P2 @ Y5 ) ) ) )
       => ( P2 @ X2 ) ) ) ).

% infinite_descent0_measure
thf(fact_151_not__less__less__Suc__eq,axiom,
    ! [N: nat,M: nat] :
      ( ~ ( ord_less @ nat @ N @ M )
     => ( ( ord_less @ nat @ N @ ( suc @ M ) )
        = ( N = M ) ) ) ).

% not_less_less_Suc_eq
thf(fact_152_strict__inc__induct,axiom,
    ! [I2: nat,J: nat,P2: nat > $o] :
      ( ( ord_less @ nat @ I2 @ J )
     => ( ! [I3: nat] :
            ( ( J
              = ( suc @ I3 ) )
           => ( P2 @ I3 ) )
       => ( ! [I3: nat] :
              ( ( ord_less @ nat @ I3 @ J )
             => ( ( P2 @ ( suc @ I3 ) )
               => ( P2 @ I3 ) ) )
         => ( P2 @ I2 ) ) ) ) ).

% strict_inc_induct
thf(fact_153_less__Suc__induct,axiom,
    ! [I2: nat,J: nat,P2: nat > nat > $o] :
      ( ( ord_less @ nat @ I2 @ J )
     => ( ! [I3: nat] : ( P2 @ I3 @ ( suc @ I3 ) )
       => ( ! [I3: nat,J2: nat,K2: nat] :
              ( ( ord_less @ nat @ I3 @ J2 )
             => ( ( ord_less @ nat @ J2 @ K2 )
               => ( ( P2 @ I3 @ J2 )
                 => ( ( P2 @ J2 @ K2 )
                   => ( P2 @ I3 @ K2 ) ) ) ) )
         => ( P2 @ I2 @ J ) ) ) ) ).

% less_Suc_induct
thf(fact_154_less__trans__Suc,axiom,
    ! [I2: nat,J: nat,K: nat] :
      ( ( ord_less @ nat @ I2 @ J )
     => ( ( ord_less @ nat @ J @ K )
       => ( ord_less @ nat @ ( suc @ I2 ) @ K ) ) ) ).

% less_trans_Suc
thf(fact_155_Suc__less__SucD,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( suc @ M ) @ ( suc @ N ) )
     => ( ord_less @ nat @ M @ N ) ) ).

% Suc_less_SucD
thf(fact_156_less__antisym,axiom,
    ! [N: nat,M: nat] :
      ( ~ ( ord_less @ nat @ N @ M )
     => ( ( ord_less @ nat @ N @ ( suc @ M ) )
       => ( M = N ) ) ) ).

% less_antisym
thf(fact_157_Suc__less__eq2,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less @ nat @ ( suc @ N ) @ M )
      = ( ? [M4: nat] :
            ( ( M
              = ( suc @ M4 ) )
            & ( ord_less @ nat @ N @ M4 ) ) ) ) ).

% Suc_less_eq2
thf(fact_158_All__less__Suc,axiom,
    ! [N: nat,P2: nat > $o] :
      ( ( ! [I4: nat] :
            ( ( ord_less @ nat @ I4 @ ( suc @ N ) )
           => ( P2 @ I4 ) ) )
      = ( ( P2 @ N )
        & ! [I4: nat] :
            ( ( ord_less @ nat @ I4 @ N )
           => ( P2 @ I4 ) ) ) ) ).

% All_less_Suc
thf(fact_159_not__less__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ~ ( ord_less @ nat @ M @ N ) )
      = ( ord_less @ nat @ N @ ( suc @ M ) ) ) ).

% not_less_eq
thf(fact_160_less__Suc__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ ( suc @ N ) )
      = ( ( ord_less @ nat @ M @ N )
        | ( M = N ) ) ) ).

% less_Suc_eq
thf(fact_161_Ex__less__Suc,axiom,
    ! [N: nat,P2: nat > $o] :
      ( ( ? [I4: nat] :
            ( ( ord_less @ nat @ I4 @ ( suc @ N ) )
            & ( P2 @ I4 ) ) )
      = ( ( P2 @ N )
        | ? [I4: nat] :
            ( ( ord_less @ nat @ I4 @ N )
            & ( P2 @ I4 ) ) ) ) ).

% Ex_less_Suc
thf(fact_162_less__SucI,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( ord_less @ nat @ M @ ( suc @ N ) ) ) ).

% less_SucI
thf(fact_163_less__SucE,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ ( suc @ N ) )
     => ( ~ ( ord_less @ nat @ M @ N )
       => ( M = N ) ) ) ).

% less_SucE
thf(fact_164_Suc__lessI,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ N )
     => ( ( ( suc @ M )
         != N )
       => ( ord_less @ nat @ ( suc @ M ) @ N ) ) ) ).

% Suc_lessI
thf(fact_165_Suc__lessE,axiom,
    ! [I2: nat,K: nat] :
      ( ( ord_less @ nat @ ( suc @ I2 ) @ K )
     => ~ ! [J2: nat] :
            ( ( ord_less @ nat @ I2 @ J2 )
           => ( K
             != ( suc @ J2 ) ) ) ) ).

% Suc_lessE
thf(fact_166_Suc__lessD,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( suc @ M ) @ N )
     => ( ord_less @ nat @ M @ N ) ) ).

% Suc_lessD
thf(fact_167_Nat_OlessE,axiom,
    ! [I2: nat,K: nat] :
      ( ( ord_less @ nat @ I2 @ K )
     => ( ( K
         != ( suc @ I2 ) )
       => ~ ! [J2: nat] :
              ( ( ord_less @ nat @ I2 @ J2 )
             => ( K
               != ( suc @ J2 ) ) ) ) ) ).

% Nat.lessE
thf(fact_168_Rats__inverse,axiom,
    ! [A: $tType] :
      ( ( field_char_0 @ A )
     => ! [A5: A] :
          ( ( member @ A @ A5 @ ( field_char_0_Rats @ A ) )
         => ( member @ A @ ( inverse_inverse @ A @ A5 ) @ ( field_char_0_Rats @ A ) ) ) ) ).

% Rats_inverse
thf(fact_169_nat__neq__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( M != N )
      = ( ( ord_less @ nat @ M @ N )
        | ( ord_less @ nat @ N @ M ) ) ) ).

% nat_neq_iff
thf(fact_170_less__not__refl,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ N ) ).

% less_not_refl
thf(fact_171_less__not__refl2,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less @ nat @ N @ M )
     => ( M != N ) ) ).

% less_not_refl2
thf(fact_172_less__not__refl3,axiom,
    ! [S: nat,T: nat] :
      ( ( ord_less @ nat @ S @ T )
     => ( S != T ) ) ).

% less_not_refl3
thf(fact_173_measure__induct,axiom,
    ! [B: $tType,A: $tType] :
      ( ( wellorder @ B )
     => ! [F: A > B,P2: A > $o,A5: A] :
          ( ! [X3: A] :
              ( ! [Y5: A] :
                  ( ( ord_less @ B @ ( F @ Y5 ) @ ( F @ X3 ) )
                 => ( P2 @ Y5 ) )
             => ( P2 @ X3 ) )
         => ( P2 @ A5 ) ) ) ).

% measure_induct
thf(fact_174_less__irrefl__nat,axiom,
    ! [N: nat] :
      ~ ( ord_less @ nat @ N @ N ) ).

% less_irrefl_nat
thf(fact_175_nat__less__induct,axiom,
    ! [P2: nat > $o,N: nat] :
      ( ! [N2: nat] :
          ( ! [M3: nat] :
              ( ( ord_less @ nat @ M3 @ N2 )
             => ( P2 @ M3 ) )
         => ( P2 @ N2 ) )
     => ( P2 @ N ) ) ).

% nat_less_induct
thf(fact_176_infinite__descent,axiom,
    ! [P2: nat > $o,N: nat] :
      ( ! [N2: nat] :
          ( ~ ( P2 @ N2 )
         => ? [M3: nat] :
              ( ( ord_less @ nat @ M3 @ N2 )
              & ~ ( P2 @ M3 ) ) )
     => ( P2 @ N ) ) ).

% infinite_descent
thf(fact_177_linorder__neqE__nat,axiom,
    ! [X2: nat,Y2: nat] :
      ( ( X2 != Y2 )
     => ( ~ ( ord_less @ nat @ X2 @ Y2 )
       => ( ord_less @ nat @ Y2 @ X2 ) ) ) ).

% linorder_neqE_nat
thf(fact_178_measure__induct__rule,axiom,
    ! [B: $tType,A: $tType] :
      ( ( wellorder @ B )
     => ! [F: A > B,P2: A > $o,A5: A] :
          ( ! [X3: A] :
              ( ! [Y5: A] :
                  ( ( ord_less @ B @ ( F @ Y5 ) @ ( F @ X3 ) )
                 => ( P2 @ Y5 ) )
             => ( P2 @ X3 ) )
         => ( P2 @ A5 ) ) ) ).

% measure_induct_rule
thf(fact_179_infinite__descent__measure,axiom,
    ! [A: $tType,P2: A > $o,V: A > nat,X2: A] :
      ( ! [X3: A] :
          ( ~ ( P2 @ X3 )
         => ? [Y5: A] :
              ( ( ord_less @ nat @ ( V @ Y5 ) @ ( V @ X3 ) )
              & ~ ( P2 @ Y5 ) ) )
     => ( P2 @ X2 ) ) ).

% infinite_descent_measure
thf(fact_180_linorder__neqE__linordered__idom,axiom,
    ! [A: $tType] :
      ( ( linordered_idom @ A )
     => ! [X2: A,Y2: A] :
          ( ( X2 != Y2 )
         => ( ~ ( ord_less @ A @ X2 @ Y2 )
           => ( ord_less @ A @ Y2 @ X2 ) ) ) ) ).

% linorder_neqE_linordered_idom
thf(fact_181_lift__Suc__mono__less__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [F: nat > A,N: nat,M: nat] :
          ( ! [N2: nat] : ( ord_less @ A @ ( F @ N2 ) @ ( F @ ( suc @ N2 ) ) )
         => ( ( ord_less @ A @ ( F @ N ) @ ( F @ M ) )
            = ( ord_less @ nat @ N @ M ) ) ) ) ).

% lift_Suc_mono_less_iff
thf(fact_182_lift__Suc__mono__less,axiom,
    ! [A: $tType] :
      ( ( order @ A )
     => ! [F: nat > A,N: nat,N5: nat] :
          ( ! [N2: nat] : ( ord_less @ A @ ( F @ N2 ) @ ( F @ ( suc @ N2 ) ) )
         => ( ( ord_less @ nat @ N @ N5 )
           => ( ord_less @ A @ ( F @ N ) @ ( F @ N5 ) ) ) ) ) ).

% lift_Suc_mono_less
thf(fact_183_dvd__pos__nat,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
     => ( ( dvd_dvd @ nat @ M @ N )
       => ( ord_less @ nat @ ( zero_zero @ nat ) @ M ) ) ) ).

% dvd_pos_nat
thf(fact_184_finite__divisors__nat,axiom,
    ! [M: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ M )
     => ( finite_finite2 @ nat
        @ ( collect @ nat
          @ ^ [D3: nat] : ( dvd_dvd @ nat @ D3 @ M ) ) ) ) ).

% finite_divisors_nat
thf(fact_185_not__one__less__zero,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ~ ( ord_less @ A @ ( one_one @ A ) @ ( zero_zero @ A ) ) ) ).

% not_one_less_zero
thf(fact_186_zero__less__one,axiom,
    ! [A: $tType] :
      ( ( zero_less_one @ A )
     => ( ord_less @ A @ ( zero_zero @ A ) @ ( one_one @ A ) ) ) ).

% zero_less_one
thf(fact_187_less__Suc__eq__0__disj,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ M @ ( suc @ N ) )
      = ( ( M
          = ( zero_zero @ nat ) )
        | ? [J3: nat] :
            ( ( M
              = ( suc @ J3 ) )
            & ( ord_less @ nat @ J3 @ N ) ) ) ) ).

% less_Suc_eq_0_disj
thf(fact_188_gr0__implies__Suc,axiom,
    ! [N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
     => ? [M2: nat] :
          ( N
          = ( suc @ M2 ) ) ) ).

% gr0_implies_Suc
thf(fact_189_All__less__Suc2,axiom,
    ! [N: nat,P2: nat > $o] :
      ( ( ! [I4: nat] :
            ( ( ord_less @ nat @ I4 @ ( suc @ N ) )
           => ( P2 @ I4 ) ) )
      = ( ( P2 @ ( zero_zero @ nat ) )
        & ! [I4: nat] :
            ( ( ord_less @ nat @ I4 @ N )
           => ( P2 @ ( suc @ I4 ) ) ) ) ) ).

% All_less_Suc2
thf(fact_190_gr0__conv__Suc,axiom,
    ! [N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
      = ( ? [M5: nat] :
            ( N
            = ( suc @ M5 ) ) ) ) ).

% gr0_conv_Suc
thf(fact_191_Ex__less__Suc2,axiom,
    ! [N: nat,P2: nat > $o] :
      ( ( ? [I4: nat] :
            ( ( ord_less @ nat @ I4 @ ( suc @ N ) )
            & ( P2 @ I4 ) ) )
      = ( ( P2 @ ( zero_zero @ nat ) )
        | ? [I4: nat] :
            ( ( ord_less @ nat @ I4 @ N )
            & ( P2 @ ( suc @ I4 ) ) ) ) ) ).

% Ex_less_Suc2
thf(fact_192_nat__dvd__not__less,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ M )
     => ( ( ord_less @ nat @ M @ N )
       => ~ ( dvd_dvd @ nat @ N @ M ) ) ) ).

% nat_dvd_not_less
thf(fact_193_nat__induct__non__zero,axiom,
    ! [N: nat,P2: nat > $o] :
      ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N )
     => ( ( P2 @ ( one_one @ nat ) )
       => ( ! [N2: nat] :
              ( ( ord_less @ nat @ ( zero_zero @ nat ) @ N2 )
             => ( ( P2 @ N2 )
               => ( P2 @ ( suc @ N2 ) ) ) )
         => ( P2 @ N ) ) ) ) ).

% nat_induct_non_zero
thf(fact_194_less__degree__imp,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [N: nat,P: poly @ A] :
          ( ( ord_less @ nat @ N @ ( degree @ A @ P ) )
         => ? [I3: nat] :
              ( ( ord_less @ nat @ N @ I3 )
              & ( ( coeff @ A @ P @ I3 )
               != ( zero_zero @ A ) ) ) ) ) ).

% less_degree_imp
thf(fact_195_coeff__eq__0,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [P: poly @ A,N: nat] :
          ( ( ord_less @ nat @ ( degree @ A @ P ) @ N )
         => ( ( coeff @ A @ P @ N )
            = ( zero_zero @ A ) ) ) ) ).

% coeff_eq_0
thf(fact_196_gcd__nat_Onot__eq__order__implies__strict,axiom,
    ! [A5: nat,B3: nat] :
      ( ( A5 != B3 )
     => ( ( dvd_dvd @ nat @ A5 @ B3 )
       => ( ( dvd_dvd @ nat @ A5 @ B3 )
          & ( A5 != B3 ) ) ) ) ).

% gcd_nat.not_eq_order_implies_strict
thf(fact_197_gcd__nat_Ostrict__implies__not__eq,axiom,
    ! [A5: nat,B3: nat] :
      ( ( ( dvd_dvd @ nat @ A5 @ B3 )
        & ( A5 != B3 ) )
     => ( A5 != B3 ) ) ).

% gcd_nat.strict_implies_not_eq
thf(fact_198_gcd__nat_Ostrict__implies__order,axiom,
    ! [A5: nat,B3: nat] :
      ( ( ( dvd_dvd @ nat @ A5 @ B3 )
        & ( A5 != B3 ) )
     => ( dvd_dvd @ nat @ A5 @ B3 ) ) ).

% gcd_nat.strict_implies_order
thf(fact_199_gcd__nat_Ostrict__iff__order,axiom,
    ! [A5: nat,B3: nat] :
      ( ( ( dvd_dvd @ nat @ A5 @ B3 )
        & ( A5 != B3 ) )
      = ( ( dvd_dvd @ nat @ A5 @ B3 )
        & ( A5 != B3 ) ) ) ).

% gcd_nat.strict_iff_order
thf(fact_200_gcd__nat_Oorder__iff__strict,axiom,
    ( ( dvd_dvd @ nat )
    = ( ^ [A3: nat,B4: nat] :
          ( ( ( dvd_dvd @ nat @ A3 @ B4 )
            & ( A3 != B4 ) )
          | ( A3 = B4 ) ) ) ) ).

% gcd_nat.order_iff_strict
thf(fact_201_gcd__nat_Ostrict__trans2,axiom,
    ! [A5: nat,B3: nat,C2: nat] :
      ( ( ( dvd_dvd @ nat @ A5 @ B3 )
        & ( A5 != B3 ) )
     => ( ( dvd_dvd @ nat @ B3 @ C2 )
       => ( ( dvd_dvd @ nat @ A5 @ C2 )
          & ( A5 != C2 ) ) ) ) ).

% gcd_nat.strict_trans2
thf(fact_202_gcd__nat_Ostrict__trans1,axiom,
    ! [A5: nat,B3: nat,C2: nat] :
      ( ( dvd_dvd @ nat @ A5 @ B3 )
     => ( ( ( dvd_dvd @ nat @ B3 @ C2 )
          & ( B3 != C2 ) )
       => ( ( dvd_dvd @ nat @ A5 @ C2 )
          & ( A5 != C2 ) ) ) ) ).

% gcd_nat.strict_trans1
thf(fact_203_gcd__nat_Ostrict__trans,axiom,
    ! [A5: nat,B3: nat,C2: nat] :
      ( ( ( dvd_dvd @ nat @ A5 @ B3 )
        & ( A5 != B3 ) )
     => ( ( ( dvd_dvd @ nat @ B3 @ C2 )
          & ( B3 != C2 ) )
       => ( ( dvd_dvd @ nat @ A5 @ C2 )
          & ( A5 != C2 ) ) ) ) ).

% gcd_nat.strict_trans
thf(fact_204_gcd__nat_Oantisym,axiom,
    ! [A5: nat,B3: nat] :
      ( ( dvd_dvd @ nat @ A5 @ B3 )
     => ( ( dvd_dvd @ nat @ B3 @ A5 )
       => ( A5 = B3 ) ) ) ).

% gcd_nat.antisym
thf(fact_205_gcd__nat_Oirrefl,axiom,
    ! [A5: nat] :
      ~ ( ( dvd_dvd @ nat @ A5 @ A5 )
        & ( A5 != A5 ) ) ).

% gcd_nat.irrefl
thf(fact_206_gcd__nat_Oeq__iff,axiom,
    ( ( ^ [Y: nat,Z: nat] : ( Y = Z ) )
    = ( ^ [A3: nat,B4: nat] :
          ( ( dvd_dvd @ nat @ A3 @ B4 )
          & ( dvd_dvd @ nat @ B4 @ A3 ) ) ) ) ).

% gcd_nat.eq_iff
thf(fact_207_gcd__nat_Otrans,axiom,
    ! [A5: nat,B3: nat,C2: nat] :
      ( ( dvd_dvd @ nat @ A5 @ B3 )
     => ( ( dvd_dvd @ nat @ B3 @ C2 )
       => ( dvd_dvd @ nat @ A5 @ C2 ) ) ) ).

% gcd_nat.trans
thf(fact_208_gcd__nat_Orefl,axiom,
    ! [A5: nat] : ( dvd_dvd @ nat @ A5 @ A5 ) ).

% gcd_nat.refl
thf(fact_209_gcd__nat_Oasym,axiom,
    ! [A5: nat,B3: nat] :
      ( ( ( dvd_dvd @ nat @ A5 @ B3 )
        & ( A5 != B3 ) )
     => ~ ( ( dvd_dvd @ nat @ B3 @ A5 )
          & ( B3 != A5 ) ) ) ).

% gcd_nat.asym
thf(fact_210_coeff__poly__cutoff,axiom,
    ! [A: $tType] :
      ( ( zero @ A )
     => ! [K: nat,N: nat,P: poly @ A] :
          ( ( ( ord_less @ nat @ K @ N )
           => ( ( coeff @ A @ ( poly_cutoff @ A @ N @ P ) @ K )
              = ( coeff @ A @ P @ K ) ) )
          & ( ~ ( ord_less @ nat @ K @ N )
           => ( ( coeff @ A @ ( poly_cutoff @ A @ N @ P ) @ K )
              = ( zero_zero @ A ) ) ) ) ) ).

% coeff_poly_cutoff
thf(fact_211_gcd__nat_Oextremum,axiom,
    ! [A5: nat] : ( dvd_dvd @ nat @ A5 @ ( zero_zero @ nat ) ) ).

% gcd_nat.extremum
thf(fact_212_gcd__nat_Oextremum__strict,axiom,
    ! [A5: nat] :
      ~ ( ( dvd_dvd @ nat @ ( zero_zero @ nat ) @ A5 )
        & ( ( zero_zero @ nat )
         != A5 ) ) ).

% gcd_nat.extremum_strict
thf(fact_213_gcd__nat_Oextremum__unique,axiom,
    ! [A5: nat] :
      ( ( dvd_dvd @ nat @ ( zero_zero @ nat ) @ A5 )
      = ( A5
        = ( zero_zero @ nat ) ) ) ).

% gcd_nat.extremum_unique
thf(fact_214_inverse__positive__iff__positive,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A5: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( inverse_inverse @ A @ A5 ) )
          = ( ord_less @ A @ ( zero_zero @ A ) @ A5 ) ) ) ).

% inverse_positive_iff_positive
thf(fact_215_inverse__negative__iff__negative,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A5: A] :
          ( ( ord_less @ A @ ( inverse_inverse @ A @ A5 ) @ ( zero_zero @ A ) )
          = ( ord_less @ A @ A5 @ ( zero_zero @ A ) ) ) ) ).

% inverse_negative_iff_negative
thf(fact_216_inverse__less__iff__less__neg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A5: A,B3: A] :
          ( ( ord_less @ A @ A5 @ ( zero_zero @ A ) )
         => ( ( ord_less @ A @ B3 @ ( zero_zero @ A ) )
           => ( ( ord_less @ A @ ( inverse_inverse @ A @ A5 ) @ ( inverse_inverse @ A @ B3 ) )
              = ( ord_less @ A @ B3 @ A5 ) ) ) ) ) ).

% inverse_less_iff_less_neg
thf(fact_217_inverse__less__iff__less,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A5: A,B3: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A5 )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ B3 )
           => ( ( ord_less @ A @ ( inverse_inverse @ A @ A5 ) @ ( inverse_inverse @ A @ B3 ) )
              = ( ord_less @ A @ B3 @ A5 ) ) ) ) ) ).

% inverse_less_iff_less
thf(fact_218_inverse__zero,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ( ( inverse_inverse @ A @ ( zero_zero @ A ) )
        = ( zero_zero @ A ) ) ) ).

% inverse_zero
thf(fact_219_inverse__nonzero__iff__nonzero,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [A5: A] :
          ( ( ( inverse_inverse @ A @ A5 )
            = ( zero_zero @ A ) )
          = ( A5
            = ( zero_zero @ A ) ) ) ) ).

% inverse_nonzero_iff_nonzero
thf(fact_220_inverse__eq__1__iff,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ! [X2: A] :
          ( ( ( inverse_inverse @ A @ X2 )
            = ( one_one @ A ) )
          = ( X2
            = ( one_one @ A ) ) ) ) ).

% inverse_eq_1_iff
thf(fact_221_inverse__1,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ( ( inverse_inverse @ A @ ( one_one @ A ) )
        = ( one_one @ A ) ) ) ).

% inverse_1
thf(fact_222_finite__psubset__induct,axiom,
    ! [A: $tType,A4: set @ A,P2: ( set @ A ) > $o] :
      ( ( finite_finite2 @ A @ A4 )
     => ( ! [A6: set @ A] :
            ( ( finite_finite2 @ A @ A6 )
           => ( ! [B5: set @ A] :
                  ( ( ord_less @ ( set @ A ) @ B5 @ A6 )
                 => ( P2 @ B5 ) )
             => ( P2 @ A6 ) ) )
       => ( P2 @ A4 ) ) ) ).

% finite_psubset_induct
thf(fact_223_strict__subset__divisors__dvd,axiom,
    ! [A: $tType] :
      ( ( comm_monoid_mult @ A )
     => ! [A5: A,B3: A] :
          ( ( ord_less @ ( set @ A )
            @ ( collect @ A
              @ ^ [C3: A] : ( dvd_dvd @ A @ C3 @ A5 ) )
            @ ( collect @ A
              @ ^ [C3: A] : ( dvd_dvd @ A @ C3 @ B3 ) ) )
          = ( ( dvd_dvd @ A @ A5 @ B3 )
            & ~ ( dvd_dvd @ A @ B3 @ A5 ) ) ) ) ).

% strict_subset_divisors_dvd
thf(fact_224_poly__IVT__pos,axiom,
    ! [A5: real,B3: real,P: poly @ real] :
      ( ( ord_less @ real @ A5 @ B3 )
     => ( ( ord_less @ real @ ( poly2 @ real @ P @ A5 ) @ ( zero_zero @ real ) )
       => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ P @ B3 ) )
         => ? [X3: real] :
              ( ( ord_less @ real @ A5 @ X3 )
              & ( ord_less @ real @ X3 @ B3 )
              & ( ( poly2 @ real @ P @ X3 )
                = ( zero_zero @ real ) ) ) ) ) ) ).

% poly_IVT_pos
thf(fact_225_poly__IVT__neg,axiom,
    ! [A5: real,B3: real,P: poly @ real] :
      ( ( ord_less @ real @ A5 @ B3 )
     => ( ( ord_less @ real @ ( zero_zero @ real ) @ ( poly2 @ real @ P @ A5 ) )
       => ( ( ord_less @ real @ ( poly2 @ real @ P @ B3 ) @ ( zero_zero @ real ) )
         => ? [X3: real] :
              ( ( ord_less @ real @ A5 @ X3 )
              & ( ord_less @ real @ X3 @ B3 )
              & ( ( poly2 @ real @ P @ X3 )
                = ( zero_zero @ real ) ) ) ) ) ) ).

% poly_IVT_neg
thf(fact_226_dvd__field__iff,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ( ( dvd_dvd @ A )
        = ( ^ [A3: A,B4: A] :
              ( ( A3
                = ( zero_zero @ A ) )
             => ( B4
                = ( zero_zero @ A ) ) ) ) ) ) ).

% dvd_field_iff
thf(fact_227_field__class_Ofield__inverse__zero,axiom,
    ! [A: $tType] :
      ( ( field @ A )
     => ( ( inverse_inverse @ A @ ( zero_zero @ A ) )
        = ( zero_zero @ A ) ) ) ).

% field_class.field_inverse_zero
thf(fact_228_inverse__zero__imp__zero,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [A5: A] :
          ( ( ( inverse_inverse @ A @ A5 )
            = ( zero_zero @ A ) )
         => ( A5
            = ( zero_zero @ A ) ) ) ) ).

% inverse_zero_imp_zero
thf(fact_229_nonzero__inverse__eq__imp__eq,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [A5: A,B3: A] :
          ( ( ( inverse_inverse @ A @ A5 )
            = ( inverse_inverse @ A @ B3 ) )
         => ( ( A5
             != ( zero_zero @ A ) )
           => ( ( B3
               != ( zero_zero @ A ) )
             => ( A5 = B3 ) ) ) ) ) ).

% nonzero_inverse_eq_imp_eq
thf(fact_230_nonzero__inverse__inverse__eq,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [A5: A] :
          ( ( A5
           != ( zero_zero @ A ) )
         => ( ( inverse_inverse @ A @ ( inverse_inverse @ A @ A5 ) )
            = A5 ) ) ) ).

% nonzero_inverse_inverse_eq
thf(fact_231_nonzero__imp__inverse__nonzero,axiom,
    ! [A: $tType] :
      ( ( division_ring @ A )
     => ! [A5: A] :
          ( ( A5
           != ( zero_zero @ A ) )
         => ( ( inverse_inverse @ A @ A5 )
           != ( zero_zero @ A ) ) ) ) ).

% nonzero_imp_inverse_nonzero
thf(fact_232_inverse__less__imp__less,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A5: A,B3: A] :
          ( ( ord_less @ A @ ( inverse_inverse @ A @ A5 ) @ ( inverse_inverse @ A @ B3 ) )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ A5 )
           => ( ord_less @ A @ B3 @ A5 ) ) ) ) ).

% inverse_less_imp_less
thf(fact_233_less__imp__inverse__less,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A5: A,B3: A] :
          ( ( ord_less @ A @ A5 @ B3 )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ A5 )
           => ( ord_less @ A @ ( inverse_inverse @ A @ B3 ) @ ( inverse_inverse @ A @ A5 ) ) ) ) ) ).

% less_imp_inverse_less
thf(fact_234_inverse__less__imp__less__neg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A5: A,B3: A] :
          ( ( ord_less @ A @ ( inverse_inverse @ A @ A5 ) @ ( inverse_inverse @ A @ B3 ) )
         => ( ( ord_less @ A @ B3 @ ( zero_zero @ A ) )
           => ( ord_less @ A @ B3 @ A5 ) ) ) ) ).

% inverse_less_imp_less_neg
thf(fact_235_less__imp__inverse__less__neg,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A5: A,B3: A] :
          ( ( ord_less @ A @ A5 @ B3 )
         => ( ( ord_less @ A @ B3 @ ( zero_zero @ A ) )
           => ( ord_less @ A @ ( inverse_inverse @ A @ B3 ) @ ( inverse_inverse @ A @ A5 ) ) ) ) ) ).

% less_imp_inverse_less_neg
thf(fact_236_inverse__negative__imp__negative,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A5: A] :
          ( ( ord_less @ A @ ( inverse_inverse @ A @ A5 ) @ ( zero_zero @ A ) )
         => ( ( A5
             != ( zero_zero @ A ) )
           => ( ord_less @ A @ A5 @ ( zero_zero @ A ) ) ) ) ) ).

% inverse_negative_imp_negative
thf(fact_237_inverse__positive__imp__positive,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A5: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ ( inverse_inverse @ A @ A5 ) )
         => ( ( A5
             != ( zero_zero @ A ) )
           => ( ord_less @ A @ ( zero_zero @ A ) @ A5 ) ) ) ) ).

% inverse_positive_imp_positive
thf(fact_238_negative__imp__inverse__negative,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A5: A] :
          ( ( ord_less @ A @ A5 @ ( zero_zero @ A ) )
         => ( ord_less @ A @ ( inverse_inverse @ A @ A5 ) @ ( zero_zero @ A ) ) ) ) ).

% negative_imp_inverse_negative
thf(fact_239_positive__imp__inverse__positive,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A5: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A5 )
         => ( ord_less @ A @ ( zero_zero @ A ) @ ( inverse_inverse @ A @ A5 ) ) ) ) ).

% positive_imp_inverse_positive
thf(fact_240_one__less__inverse,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [A5: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ A5 )
         => ( ( ord_less @ A @ A5 @ ( one_one @ A ) )
           => ( ord_less @ A @ ( one_one @ A ) @ ( inverse_inverse @ A @ A5 ) ) ) ) ) ).

% one_less_inverse
thf(fact_241_one__less__inverse__iff,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [X2: A] :
          ( ( ord_less @ A @ ( one_one @ A ) @ ( inverse_inverse @ A @ X2 ) )
          = ( ( ord_less @ A @ ( zero_zero @ A ) @ X2 )
            & ( ord_less @ A @ X2 @ ( one_one @ A ) ) ) ) ) ).

% one_less_inverse_iff
thf(fact_242_less__numeral__extra_I1_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ( ord_less @ A @ ( zero_zero @ A ) @ ( one_one @ A ) ) ) ).

% less_numeral_extra(1)
thf(fact_243_finite__M__bounded__by__nat,axiom,
    ! [P2: nat > $o,I2: nat] :
      ( finite_finite2 @ nat
      @ ( collect @ nat
        @ ^ [K3: nat] :
            ( ( P2 @ K3 )
            & ( ord_less @ nat @ K3 @ I2 ) ) ) ) ).

% finite_M_bounded_by_nat
thf(fact_244_less__numeral__extra_I3_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ~ ( ord_less @ A @ ( zero_zero @ A ) @ ( zero_zero @ A ) ) ) ).

% less_numeral_extra(3)
thf(fact_245_less__numeral__extra_I4_J,axiom,
    ! [A: $tType] :
      ( ( linord1659791738miring @ A )
     => ~ ( ord_less @ A @ ( one_one @ A ) @ ( one_one @ A ) ) ) ).

% less_numeral_extra(4)
thf(fact_246_Rats__dense__in__real,axiom,
    ! [X2: real,Y2: real] :
      ( ( ord_less @ real @ X2 @ Y2 )
     => ? [X3: real] :
          ( ( member @ real @ X3 @ ( field_char_0_Rats @ real ) )
          & ( ord_less @ real @ X2 @ X3 )
          & ( ord_less @ real @ X3 @ Y2 ) ) ) ).

% Rats_dense_in_real
thf(fact_247_Rats__no__bot__less,axiom,
    ! [X2: real] :
    ? [X3: real] :
      ( ( member @ real @ X3 @ ( field_char_0_Rats @ real ) )
      & ( ord_less @ real @ X3 @ X2 ) ) ).

% Rats_no_bot_less
thf(fact_248_field__lbound__gt__zero,axiom,
    ! [A: $tType] :
      ( ( linordered_field @ A )
     => ! [D1: A,D22: A] :
          ( ( ord_less @ A @ ( zero_zero @ A ) @ D1 )
         => ( ( ord_less @ A @ ( zero_zero @ A ) @ D22 )
           => ? [E: A] :
                ( ( ord_less @ A @ ( zero_zero @ A ) @ E )
                & ( ord_less @ A @ E @ D1 )
                & ( ord_less @ A @ E @ D22 ) ) ) ) ) ).

% field_lbound_gt_zero
thf(fact_249_pseudo__mod_I2_J,axiom,
    ! [A: $tType] :
      ( ( ( comm_ring_1 @ A )
        & ( semiri134348788visors @ A ) )
     => ! [G: poly @ A,F: poly @ A] :
          ( ( G
           != ( zero_zero @ ( poly @ A ) ) )
         => ( ( ( pseudo_mod @ A @ F @ G )
              = ( zero_zero @ ( poly @ A ) ) )
            | ( ord_less @ nat @ ( degree @ A @ ( pseudo_mod @ A @ F @ G ) ) @ ( degree @ A @ G ) ) ) ) ) ).

% pseudo_mod(2)
thf(fact_250_poly__pinfty__gt__lc,axiom,
    ! [P: poly @ real] :
      ( ( ord_less @ real @ ( zero_zero @ real ) @ ( coeff @ real @ P @ ( degree @ real @ P ) ) )
     => ? [N2: real] :
        ! [X4: real] :
          ( ( ord_less_eq @ real @ N2 @ X4 )
         => ( ord_less_eq @ real @ ( coeff @ real @ P @ ( degree @ real @ P ) ) @ ( poly2 @ real @ P @ X4 ) ) ) ) ).

% poly_pinfty_gt_lc
thf(fact_251_le__zero__eq,axiom,
    ! [A: $tType] :
      ( ( canoni770627133id_add @ A )
     => ! [N: A] :
          ( ( ord_less_eq @ A @ N @ ( zero_zero @ A ) )
          = ( N
            = ( zero_zero @ A ) ) ) ) ).

% le_zero_eq

% Type constructors (64)
thf(tcon_fun___Finite__Set_Ofinite,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( ( finite_finite @ A7 )
        & ( finite_finite @ A8 ) )
     => ( finite_finite @ ( A7 > A8 ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A7: $tType,A8: $tType] :
      ( ( order @ A8 )
     => ( order @ ( A7 > A8 ) ) ) ).

thf(tcon_Nat_Onat___Groups_Ocanonically__ordered__monoid__add,axiom,
    canoni770627133id_add @ nat ).

thf(tcon_Nat_Onat___Rings_Osemiring__1__no__zero__divisors,axiom,
    semiri134348788visors @ nat ).

thf(tcon_Nat_Onat___Rings_Olinordered__nonzero__semiring,axiom,
    linord1659791738miring @ nat ).

thf(tcon_Nat_Onat___Rings_Osemiring__no__zero__divisors,axiom,
    semiri1193490041visors @ nat ).

thf(tcon_Nat_Onat___Rings_Oalgebraic__semidom,axiom,
    algebraic_semidom @ nat ).

thf(tcon_Nat_Onat___Groups_Ocomm__monoid__mult,axiom,
    comm_monoid_mult @ nat ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring__1,axiom,
    comm_semiring_1 @ nat ).

thf(tcon_Nat_Onat___Rings_Ocomm__semiring__0,axiom,
    comm_semiring_0 @ nat ).

thf(tcon_Nat_Onat___Rings_Ozero__less__one,axiom,
    zero_less_one @ nat ).

thf(tcon_Nat_Onat___Orderings_Owellorder,axiom,
    wellorder @ nat ).

thf(tcon_Nat_Onat___Nat_Osemiring__char__0,axiom,
    semiring_char_0 @ nat ).

thf(tcon_Nat_Onat___Rings_Ozero__neq__one,axiom,
    zero_neq_one @ nat ).

thf(tcon_Nat_Onat___Orderings_Oorder_1,axiom,
    order @ nat ).

thf(tcon_Nat_Onat___Groups_Ozero,axiom,
    zero @ nat ).

thf(tcon_Nat_Onat___Groups_Oone,axiom,
    one @ nat ).

thf(tcon_Set_Oset___Finite__Set_Ofinite_2,axiom,
    ! [A7: $tType] :
      ( ( finite_finite @ A7 )
     => ( finite_finite @ ( set @ A7 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_3,axiom,
    ! [A7: $tType] : ( order @ ( set @ A7 ) ) ).

thf(tcon_HOL_Obool___Finite__Set_Ofinite_4,axiom,
    finite_finite @ $o ).

thf(tcon_HOL_Obool___Orderings_Oorder_5,axiom,
    order @ $o ).

thf(tcon_Real_Oreal___Rings_Osemiring__1__no__zero__divisors_6,axiom,
    semiri134348788visors @ real ).

thf(tcon_Real_Oreal___Rings_Olinordered__nonzero__semiring_7,axiom,
    linord1659791738miring @ real ).

thf(tcon_Real_Oreal___Rings_Osemiring__no__zero__divisors_8,axiom,
    semiri1193490041visors @ real ).

thf(tcon_Real_Oreal___Rings_Oring__no__zero__divisors,axiom,
    ring_n68954251visors @ real ).

thf(tcon_Real_Oreal___Groups_Ocomm__monoid__mult_9,axiom,
    comm_monoid_mult @ real ).

thf(tcon_Real_Oreal___Fields_Olinordered__field,axiom,
    linordered_field @ real ).

thf(tcon_Real_Oreal___Rings_Olinordered__idom,axiom,
    linordered_idom @ real ).

thf(tcon_Real_Oreal___Rings_Ocomm__semiring__1_10,axiom,
    comm_semiring_1 @ real ).

thf(tcon_Real_Oreal___Rings_Ocomm__semiring__0_11,axiom,
    comm_semiring_0 @ real ).

thf(tcon_Real_Oreal___Fields_Odivision__ring,axiom,
    division_ring @ real ).

thf(tcon_Real_Oreal___Rings_Ozero__less__one_12,axiom,
    zero_less_one @ real ).

thf(tcon_Real_Oreal___Nat_Osemiring__char__0_13,axiom,
    semiring_char_0 @ real ).

thf(tcon_Real_Oreal___Fields_Ofield__char__0,axiom,
    field_char_0 @ real ).

thf(tcon_Real_Oreal___Rings_Ozero__neq__one_14,axiom,
    zero_neq_one @ real ).

thf(tcon_Real_Oreal___Rings_Oidom__divide,axiom,
    idom_divide @ real ).

thf(tcon_Real_Oreal___Rings_Ocomm__ring__1,axiom,
    comm_ring_1 @ real ).

thf(tcon_Real_Oreal___Orderings_Oorder_15,axiom,
    order @ real ).

thf(tcon_Real_Oreal___Nat_Oring__char__0,axiom,
    ring_char_0 @ real ).

thf(tcon_Real_Oreal___Rings_Oring__1,axiom,
    ring_1 @ real ).

thf(tcon_Real_Oreal___Fields_Ofield,axiom,
    field @ real ).

thf(tcon_Real_Oreal___Groups_Ozero_16,axiom,
    zero @ real ).

thf(tcon_Real_Oreal___Rings_Oidom,axiom,
    idom @ real ).

thf(tcon_Real_Oreal___Groups_Oone_17,axiom,
    one @ real ).

thf(tcon_Polynomial_Opoly___Rings_Osemiring__1__no__zero__divisors_18,axiom,
    ! [A7: $tType] :
      ( ( ( comm_semiring_1 @ A7 )
        & ( semiri134348788visors @ A7 ) )
     => ( semiri134348788visors @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Olinordered__nonzero__semiring_19,axiom,
    ! [A7: $tType] :
      ( ( linordered_idom @ A7 )
     => ( linord1659791738miring @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Osemiring__no__zero__divisors_20,axiom,
    ! [A7: $tType] :
      ( ( ( comm_semiring_0 @ A7 )
        & ( semiri1193490041visors @ A7 ) )
     => ( semiri1193490041visors @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Oring__no__zero__divisors_21,axiom,
    ! [A7: $tType] :
      ( ( idom @ A7 )
     => ( ring_n68954251visors @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Oalgebraic__semidom_22,axiom,
    ! [A7: $tType] :
      ( ( idom_divide @ A7 )
     => ( algebraic_semidom @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Ocomm__monoid__mult_23,axiom,
    ! [A7: $tType] :
      ( ( comm_semiring_1 @ A7 )
     => ( comm_monoid_mult @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Olinordered__idom_24,axiom,
    ! [A7: $tType] :
      ( ( linordered_idom @ A7 )
     => ( linordered_idom @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ocomm__semiring__1_25,axiom,
    ! [A7: $tType] :
      ( ( comm_semiring_1 @ A7 )
     => ( comm_semiring_1 @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ocomm__semiring__0_26,axiom,
    ! [A7: $tType] :
      ( ( comm_semiring_0 @ A7 )
     => ( comm_semiring_0 @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ozero__less__one_27,axiom,
    ! [A7: $tType] :
      ( ( linordered_idom @ A7 )
     => ( zero_less_one @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Nat_Osemiring__char__0_28,axiom,
    ! [A7: $tType] :
      ( ( ( ring_char_0 @ A7 )
        & ( comm_ring_1 @ A7 ) )
     => ( semiring_char_0 @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ozero__neq__one_29,axiom,
    ! [A7: $tType] :
      ( ( comm_semiring_1 @ A7 )
     => ( zero_neq_one @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Oidom__divide_30,axiom,
    ! [A7: $tType] :
      ( ( idom_divide @ A7 )
     => ( idom_divide @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Ocomm__ring__1_31,axiom,
    ! [A7: $tType] :
      ( ( comm_ring_1 @ A7 )
     => ( comm_ring_1 @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Orderings_Oorder_32,axiom,
    ! [A7: $tType] :
      ( ( linordered_idom @ A7 )
     => ( order @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Nat_Oring__char__0_33,axiom,
    ! [A7: $tType] :
      ( ( ( ring_char_0 @ A7 )
        & ( comm_ring_1 @ A7 ) )
     => ( ring_char_0 @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Oring__1_34,axiom,
    ! [A7: $tType] :
      ( ( comm_ring_1 @ A7 )
     => ( ring_1 @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Ozero_35,axiom,
    ! [A7: $tType] :
      ( ( zero @ A7 )
     => ( zero @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Rings_Oidom_36,axiom,
    ! [A7: $tType] :
      ( ( idom @ A7 )
     => ( idom @ ( poly @ A7 ) ) ) ).

thf(tcon_Polynomial_Opoly___Groups_Oone_37,axiom,
    ! [A7: $tType] :
      ( ( comm_semiring_1 @ A7 )
     => ( one @ ( poly @ A7 ) ) ) ).

% Conjectures (1)
thf(conj_0,conjecture,
    ( finite_finite2 @ real
    @ ( collect @ real
      @ ^ [X: real] :
          ( ( poly2 @ real @ ( pderiv @ real @ p ) @ X )
          = ( zero_zero @ real ) ) ) ) ).

%------------------------------------------------------------------------------
